<?php
/**
 * @class nucleo
 * @package WebServices de Sincronia e Comunicação Socket - E-Garçom
 * @author Willian Nascimento <willian@ecletica.com.br>
 * @author Rafael Pelegrini   <rafael@ecletica.com.br>
 * @copyright Copyright (c) 2016, Eclética Informática
 * @version 1.8.0
 */

ini_set('display_errors', 'on');
error_reporting(E_ERROR);
//error_reporting(0);

header("Content-Type: application/json; charset=UTF-8",true);
header("Access-Control-Allow-Origin: *");
header('Access-Control-Allow-Methods: GET, POST');
header("Access-Control-Allow-Headers: Accept, Content-Type, loginToken, X-Requested-With");

class nucleo {
    
    protected $app;
    protected $__bd;
    protected $_externo = false;
    
    function __construct() {
        
        
        require_once '../REST/Slim/Slim.php';
        
        /**
        * Carrega o registrador de autoloader do SlimPHP
        */
        \Slim\Slim::registerAutoloader();
        
        /**
        * Instância da classe SlimPHP 
        * @return Object
        */
        $this->app = new \Slim\Slim();
        
        //Desabilita modo debug para conseguir pegar erros 500 como os casos de JSON no POST incorreto
        $this->app->config( 'debug', false );
        
        /**
        * Configura resposta do cabeçalho para json e codificação utf-8
        */
        $this->app->response()->header( 'Content-Type', 'application/json;charset=utf-8' );
        $this->app->response()->header( 'Access-Control-Allow-Origin', '*' );
        $this->app->response()->header( 'Access-Control-Allow-Methods', 'GET, POST' );
        $this->app->response()->header( 'Access-Control-Allow-Headers', 'Accept, Content-Type, loginToken, X-Requested-With' );
        
        /**
        * Verifica problemas na URL da requisição para evitar erro de página não encontrada (404)
        */

        
        $this->app->notFound( function () {
            $d = array( 'motivo' => utf8_encode( 'Verifique se os parâmetros da requisição (Nome do Metodo, rede ou loja) estão corretos. Verifique inclusive se o verbo HTTP é o mesmo requerido na chamada do método (POST, GET).' ) );
            $this->rMsg( "009", "Parâmetros da URL inválidos", $d );
        });
        
        /**
        * Verifica erros desconhecidos tipo 500
        */
        $this->app->error( function ( Exception $e ){
            $d = array( 'motivo' => utf8_encode( 'Se a requisição for POST, verifique se o objeto JSON enviado está correto.' ), 'mensagem' => $e->getMessage().' - linha:'.$e->getLine() . ' - file:' .$e->getFile() ); 

            $this->rMsg( "999", "Erro Desconhecido", $d ); 
        });
        
        
    }
    
    protected function getMySQLi( $host, $porta, $user, $pwd, $base = "ecleticavendas" ){
        
        try{
            
            return new mysqli( $host.':'.$porta, $user, $pwd, $base );
            
        } catch (Exception $ex) {
            
            $d = array( 'motivo' => utf8_encode( 'Não foi possível conectar ao serviço de MySQL no IP: ' . $host . ' verifique se o serviço está disponível' ), 'detalhes' => $ex->getMessage() . ' - linha:' . $ex->getLine() . ' - ' . $ex->getFile() );
            $this->rMsg( "007", "Falha ao conectar com MySQL", $d ); 
            exit();
        }
        
        
    }
    
    /**
    * Função que retorna Respostas JSON
    */
    protected function rMsg( $cod, $msg, $dados=0 ){

        $rMsg = array();

        $rMsg['cod'] = $cod;
        $rMsg['msg'] = $msg;

        if( $dados ){
            $rMsg['dados_adicionais'] = $dados;
        }

        echo json_encode( $rMsg );

        exit(); 
    }


    protected function validaHash( $loginToken ){
        
        require_once '../REST/seguranca/hashes.php';
        
        if( ! ( in_array( $loginToken, $hash ) ) ){
            $this->rMsg( "001", "Falha na autenticação", 0 );
            exit();
        }

        if( $loginToken != "c8567f1f1ba8b9633947819de9af50ec29c2ead1" ){
            $this->_externo = true;
        }

    }
}
