<?php
/**
 * @class negocio
 * @package WebService de Sincronia de Informações e Comunicação via Socket - E-Garçom
 * @author Willian Nascimento <willian@ecletica.com.br>
 * @author Rafael Pelegrini   <rafael@ecletica.com.br>
 * @copyright Copyright (c) 2016, Eclética Informática
 * @version 1.8.0
 */

ini_set('display_errors', 'on');
error_reporting(E_ERROR);
//error_reporting(0);

class negocio extends nucleo {
    
    function __construct() {
        parent::__construct();
    }
    
    /**
     * Envia Venda para o Caixa
     * @return array Array com os dados de retorno da venda
     */
    protected $DadosVenda = array();
    
    protected function efetuaVenda( $json, $host, $porta ){
        
        $efetua_venda = $this->socketConnect( $json, $host, $porta, 1024000 );
        
        return $efetua_venda;
        
    }

    /**
     * Envia Venda para o Caixa vindo de integradores externos
     * @return array Array com os dados de retorno da venda
     */
    protected $DadosVendaExterno = array();
    
    protected function efetuaVendaExterno( $json, $host, $porta ){
        
        $efetua_venda = $this->socketConnectExterno( $json, $host, $porta, 1024000 );
        
        return $efetua_venda;
        
    }
    
    /**
     * Efetua o Cancelamento da Venda no Caixa
     * @return array Array com os dados de retorno do cancelamento
     */
    protected $DadosCancelamento = array();
    
    protected function cancelaVenda( $json, $host, $porta ){
        
        $cancela_venda = $this->socketConnect( $json, $host, $porta );
        
        return $cancela_venda;
        
    }
    
    /**
     * Efetua a Transferência de Itens
     * @return array Array com os dados de retorno da transferência
     */
    protected $DadosTransferencia = array();
    
    protected function transfereItens( $json, $host, $porta ){
        
        $transfere_itens = $this->socketConnect( $json, $host, $porta );
        
        return $transfere_itens;
        
    }
    
    
    /**
     * Cancelamento de Itens
     * @return array Array com os dados de retorno do cancelamento dos itens
     */
    protected $DadosCancelamentoItens = array();
    
    protected function cancelaItens( $json, $host, $porta ){
        
        $cancela_itens = $this->socketConnect( $json, $host, $porta );
        
        return $cancela_itens;
        
    }
    
    /**
     * Efetua o Envio de Pre Fechamento
     * @return array Array com os dados de envio de pre fechamento
     */
    protected $DadosEnvioPreFechamento = array();
    
    protected function enviaPreFechamento( $json, $host, $porta ){
 
        $pre_fechamento = $this->socketConnect( $json, $host, $porta, 1024000 );
        
        return $pre_fechamento;
        
    }

    /**
     * Efetua o Envio de Fechar Conta
     * @return array Array com os dados de envio de fechamento de conta
     */
    protected $DadosEnvioFechaConta = array();
    
    protected function fecharConta( $json, $host, $porta ){
 
        $fecha_conta = $this->socketConnect( $json, $host, $porta, 7168000 );

        return $fecha_conta;
        
    }


    /**
     * Chamar o Garcom (imprimindo no sistema a mesa que o chamou)
     * @return array Array com os dados de envio de chamada do Garcom
     */
    protected $DadosChamarGarcom = array();
    
    protected function chamarGarcom( $json, $host, $porta ){
 
        $chamar_garcom = $this->socketConnect( $json, $host, $porta );

        return $chamar_garcom;
        
    }

    /**
     * Imprimir Diversos (imprimindo no sistema cupons, cancelamentos, reimpressao de vias, etc...)
     * @return array Array com os dados de envio de chamada da impressao
     */
    
    protected function imprimeDiversosPDV( $json, $host, $porta ){
 
        $imprime_diversos = $this->socketConnect( $json, $host, $porta );

        return $imprime_diversos;
        
    }

    /**
     * Efetua o Envio de  Consulta Total Conta
     * @return array Array com os dados de envio de consulta de total da conta
     */
    protected $DadosEnvioConsultaTotalConta = array();
    
    protected function consultaTotalConta( $json, $host, $porta ){
 
        $consulta_total_conta = $this->socketConnect( $json, $host, $porta, 1024000 ); 

        return $consulta_total_conta;
        
    }

    
    /**
     * Comunicação via SOCKET com o servidor de operações para vendas de integradores externos
     * @return array Array com o retorno do server
     */
    protected function socketConnectExterno( $json, $host, $porta, $read=2048, $retry=0 ){

        try{
            $socket_cliente = @socket_create( AF_INET, SOCK_STREAM, 0 );
            
            @socket_set_option($socket_cliente,SOL_SOCKET, SO_RCVTIMEO, array("sec"=>20, "usec"=>0));
            
            //$this->gravaTXT( 'ok', 'socket_create' );
        
            if ( $socket_cliente < 0 ){
                return 'offline';
            }

            $connect = @socket_connect( $socket_cliente, $host, $porta );
            //$this->gravaTXT( 'ok', 'socket_connect' );

            if ( $connect < 0 ){
                return 'offline';
            } 

            $json = substr($json, 0, strlen($json)-1) . ',{"fim_arquivo":true}]';


            @socket_write( $socket_cliente, $json, strlen( $json ) );
            //$this->gravaTXT( 'ok', 'socket_write' );

            $msg = @socket_read( $socket_cliente, $read );

            if( ( $msg == '' ) && ( $retry <= 2 ) ){

                //$this->gravaTXT( 'ok', 'pegou_timeout_goomer' );
                @socket_close($socket_cliente);
                
                $retry+=1;
                return $this->socketConnectExterno( $json, $host, $porta, 1024000, $retry );

                
            }


            //$this->gravaTXT( 'ok', 'socket_read' );
            if ( $msg != '' ){
                return $msg;
            }else{
                return 'offline';
            }

            @socket_close($socket_cliente);
            
        } catch (Exception $ex) {
            return 'offline';
        }
        
        
    }


    /**
     * Comunicação via SOCKET com o servidor de operações
     * @return array Array com o retorno do server
     */
    protected function socketConnect( $json, $host, $porta, $read=2048 ){

        try{

            $socket_cliente = socket_create( AF_INET, SOCK_STREAM, 0 );
            
            //socket_set_option($socket_cliente,SOL_SOCKET, SO_RCVTIMEO, array("sec"=>7, "usec"=>0));
        
            if ( $socket_cliente < 0 ){
                return 'offline';
            }

            $connect = socket_connect( $socket_cliente, $host, $porta );

            if ( $connect < 0 ){
                return 'offline';
            } 

            $json = substr($json, 0, strlen($json)-1) . ',{"fim_arquivo":true}]';


            socket_write( $socket_cliente, $json, strlen( $json ) );

            $msg = @socket_read( $socket_cliente, $read );

            
            if ( $msg ){
                return $msg;
            }else{
                return 'offline';
            }

            socket_close($socket_cliente);
            
        } catch (Exception $ex) {
            return 'offline';
        }
        
        
    }

    /**
    * Grava arquivo .txt para fins de analises    
    * @return boolean true
    */
    protected function gravaTXT( $json, $nome_arquivo ){

        $dir = "logs";

        if( ! is_dir( $dir ) ){
            mkdir( 'logs', 0777, true );
        }

        $log = fopen( $dir . '/' . $nome_arquivo . "_" . time() . '.txt', 'w');
        fwrite( $log, $json );
        fclose( $log );

        return true;

    }

    /**
     * Cancelamento de Requisição
     * @return array Array com os dados de retorno do cancelamento de requisição no mercado pago
     */
    protected $DadosCancelamentoRequisicao = array();
    
    protected function cancelaRequisicaoMercadoPago( $dados_requisicao, $host, $porta ){
        
        $json = json_decode( $dados_requisicao );                
        
        $external_id = $json[0]->JSON->external_id;// nome do dispositivo no mercado pago
        $access_token = $json[0]->JSON->access_token;// hash/token usado pra todas as transações
        $collector_id = $json[0]->JSON->collector_id;// id da conta da loja no mercado pago
        $url = "https://api.mercadopago.com/mpmobile/instore/qr/".$collector_id."/".$external_id."?access_token=".$access_token;

        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => $url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "DELETE",
          CURLOPT_HTTPHEADER => array(
            "Accept: */*",
            "Accept-Encoding: gzip, deflate",
            "Cache-Control: no-cache",
            "Connection: keep-alive",
            "Content-Length: 0",
            "Host: api.mercadopago.com",
            "cache-control: no-cache"
          ),
        ));

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);


        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
          $retorno = "cURL Error #:" . $err;
        } else {
          $retorno = $response;
        }

        if(strlen($retorno) == 0){
            $retorno = '{"message":"sucesso","descricao":"requisição de cancelamento efetuada com sucesso","status":200,"cause":[]}';
        }
       
        return $retorno;
        
    }

    /**
     * Metodo de verificao/insercao de sistema de Logins
     * @return boolean Booleano com o retorno da verificacao se operador esta logado
     */
    protected function verificaLogin( $qtde_pockets, $uuid, $nome_operador, $plataforma ){
        
        $stmt = $this->__bd->query( "SELECT operador FROM operador_logado_dm WHERE operador = '".$nome_operador."' AND uuid_dispositivo = '".$uuid."' LIMIT 1", MYSQLI_STORE_RESULT );

        if( $stmt->num_rows > 0 ){
            $stmt->close();
            return true;
        }else{
            $stmt->close();

            $stmt = $this->__bd->query("SELECT COUNT(operador) as qtd_op FROM operador_logado_dm LIMIT 1", MYSQLI_STORE_RESULT);

            if( $stmt->num_rows > 0 ){

                $dados_operadores = $stmt->fetch_array();
                $qtd_operadores_logados = $dados_operadores['qtd_op'];
                $stmt->close();

                if( $qtd_operadores_logados < $qtde_pockets){
                    
                    //faz insert do login e retorna true
                    $stmt = $this->__bd->query("INSERT INTO operador_logado_dm SET operador='".$nome_operador."', uuid_dispositivo='".$uuid."', plataforma = '".$plataforma."', data_login=NOW()");
                    
                    return true;
                }else{
                    
                    return false;
                }
            }else{
                //faz insert do login e retorna true
                $stmt = $this->__bd->query("INSERT INTO operador_logado_dm SET operador='".$nome_operador."', uuid_dispositivo='".$uuid."', plataforma = '".$plataforma."', data_login=NOW()");
                
                return true;
            }

        }

    }
    

    /**
     * Metodo de verificacao/excusao de operador no sistema de Logins
     * @return boolean Booleano com o retorno da verificacao se operador foi excluido ou nao
     */
    protected function excluiLogado( $uuid, $nome_operador ){
        
        $stmt = $this->__bd->query( "SELECT operador FROM operador_logado_dm WHERE operador = '".$nome_operador."' AND uuid_dispositivo = '".$uuid."' LIMIT 1", MYSQLI_STORE_RESULT );

        if( $stmt->num_rows > 0 ){
            $stmt->close();
            //deleta
            $stmt = $this->__bd->query( "DELETE FROM operador_logado_dm WHERE operador = '".$nome_operador."' AND uuid_dispositivo = '".$uuid."' LIMIT 1");

            return true;
        }else{
            $stmt->close();
            return false;
        }
    }

    /**
     * Efetua a Gravacao do Checkin dos clientes
     * @return boolean Booleano com o retorno da gravacao
     */
    protected function gravaCheckin( $dados_checkin ){
        
        $json = json_decode( $dados_checkin );                
        $comanda = $json[0]->JSON->numero;

        $cpf = $json[0]->JSON->checkin->cpf;
        $data_nascimento = $json[0]->JSON->checkin->data_de_nascimento;
        $email = $json[0]->JSON->checkin->email; 
        $nome = $json[0]->JSON->checkin->nome;
        $numero = $json[0]->JSON->checkin->numero;
        $telefone = $json[0]->JSON->checkin->telefone;
        $tipo_cliente = $json[0]->JSON->checkin->tipo_cliente;
        $codigo_cliente = $json[0]->JSON->checkin->codigo_cliente;
        $codigo_operador = $json[0]->JSON->checkin->codigo_operador;
        $data_cadastro = date( 'Y-m-d' );        

        //VERIFICAÇÕES E INSERÇÕES EM TABELA CLIENTES
        $stmt = $this->__bd->query( "SELECT * FROM clientes 
                                        WHERE telefone = '$telefone' " );

        if( $stmt->num_rows > 0 ){
            //update
            if( $data_nascimento == '' ){
                $query = "UPDATE clientes SET razao = '$nome',cnpj = '$cpf' ,e_mail = '$email', data_aniversario = NULL ,cod_tipo_cliente = '$tipo_cliente',cadastrado_por = '$codigo_operador' WHERE telefone = '$telefone' ";
            }else{
                $query = "UPDATE clientes SET razao = '$nome',cnpj = '$cpf' ,e_mail = '$email', data_aniversario = '$data_nascimento',cod_tipo_cliente = '$tipo_cliente',cadastrado_por = '$codigo_operador' WHERE telefone = '$telefone' ";
            }

            $stmt = $this->__bd->query( $query );
            $cadastro_novo = false;
        }else{
            //insert
           
            if( $data_nascimento == '' ){
                $query = "INSERT INTO clientes SET razao = '$nome',cnpj = '$cpf',e_mail = '$email',telefone = '$telefone',data_aniversario = NULL,cod_tipo_cliente = '$tipo_cliente',cadastrado_por = '$codigo_operador',tipo_pessoa = 'F',cod_cpl = '$telefone' , data_cadastro = '$data_cadastro'  ";
            }else{
                $query = "INSERT INTO clientes SET razao = '$nome',cnpj = '$cpf',e_mail = '$email',telefone = '$telefone',data_aniversario = '$data_nascimento',cod_tipo_cliente = '$tipo_cliente',cadastrado_por = '$codigo_operador',tipo_pessoa = 'F',cod_cpl = '$telefone' , data_cadastro = '$data_cadastro' ";
            }

            $stmt = $this->__bd->query( $query );
            $cadastro_novo = true;
        }

        //select com o único intuito de pegar o cod_cli do registro inserido(ou "updatado")
        $stmt = $this->__bd->query( "SELECT cod_cli FROM clientes 
                                        WHERE telefone = '$telefone' " );

        $dados_cliente = $stmt->fetch_array();
        $codigo_cliente = $dados_cliente['cod_cli'];

        //INSERE ENDEREÇO
        //
        if($cadastro_novo === true && $stmt->num_rows > 0){

            $selecionaRegiao = $this->__bd->query( "SELECT cidade, estado
                                                        FROM configuracao_loja ");

            $dados_loja = $selecionaRegiao->fetch_array();
            $cidade = $dados_loja['cidade'];
            $estado = $dados_loja['estado'];

        
            $insereEndereco = "INSERT INTO enderecos_clientes 
                SET cod_cli = ".$codigo_cliente.", 
                cod_endereco = 1, 
                cep = '99999-999', 
                logradouro = 'RUA', 
                endereco = 'ENDEREÇO', 
                bairro = 'BAIRRO', 
                num_rua = 1, 
                cidade = '".$cidade."', 
                estado = '".$estado."',
                ativo = 'S', 
                alterado = 'S'";

            $stmt = $this->__bd->query( $insereEndereco );

        }

        //VERIFICAÇÕES E INSERÇÕES EM TABELA CHECKIN
        
        $stmt = $this->__bd->query( "SELECT * FROM checkin WHERE 
                                        num_comanda = '$comanda' AND 
                                        status = 'L' " );

        if( $stmt->num_rows > 0 ){
            //update
            if( $data_nascimento == '' ){
                $query = " UPDATE checkin SET cod_cli = '$codigo_cliente' ,nome_cli = '$nome',telefone = '$telefone',email = '$email', data_nasc = NULL WHERE num_comanda = '$comanda' ";
            }else{
                $query = " UPDATE checkin SET cod_cli = '$codigo_cliente' ,nome_cli = '$nome',telefone = '$telefone',email = '$email',data_nasc = '$data_nascimento' WHERE num_comanda = '$comanda' ";
            }

            $stmt = $this->__bd->query($query);
            return true;
        }else{
            //insert
            if( $data_nascimento == '' ){
                $query = "INSERT INTO checkin VALUES ( '$codigo_cliente','$comanda', '$nome',NULL,'$telefone','$email',0,0,'L',0,'' )";
            }else{
                $query = "INSERT INTO checkin VALUES ( '$codigo_cliente','$comanda', '$nome','$data_nascimento','$telefone','$email',0,0,'L',0,'' )";
            }

            $stmt = $this->__bd->query( $query );

            return true;
        }

        return false;
    }

    /**
     * Efetua a Consulta da Mesa em Pré Fechamento
     * @return boolean Booleano com o retorno da consulta da mesa em pré fechamento
     */
    protected function consultaMesaPreFechamento( $mesa ){
        
        $stmt = $this->__bd->query( "SELECT num_mesas FROM configuracao_loja LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $mesas = $stmt->fetch_array();
            $mesas = $mesas['num_mesas'];
        }
        
        if( $mesa > $mesas || $mesa < 0 ){
            $res['motivo'] = 'inexistente';
            return $res;
        }    
            
        $stmt = $this->__bd->query( "SELECT cod_mesa FROM vendas_pendentes WHERE cod_mesa = $mesa AND flag_aberta = 'F' LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            return true;
        }else{

            $stmt = $this->__bd->query( "SELECT cod_mesa FROM item_cancelado WHERE cod_mesa = $mesa AND flag_aberta = 'F' LIMIT 1", MYSQLI_STORE_RESULT );
            
            if( $stmt->num_rows > 0 ){
                return true;
            }
        }
        
        return false;
        
    }
    
    /**
     * Consulta de Comanda Bloqueada
     * @return array Array com os dados de retorno da consulta de comanda bloqueada
     */
    protected $DadosClienteCheckin = array();
    
    protected function consultaComandaBloqueada( $comanda, $usa_checkin ){
        
        //verifica se a comanda existe no range de comandas
        $stmt = $this->__bd->query( "SELECT num_comanda FROM numeros LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $comandas = $stmt->fetch_array();
            $comandas = $comandas['num_comanda'];
        }
        
        if( $comanda > $comandas || $comanda < 0 ){
            $res['motivo'] = 'inexistente';
            return $res;
        }
        
        //consulta se a comanda esta bloqueada
        $stmt = $this->__bd->query( "SELECT motivo FROM comanda_bloq WHERE num_comanda = $comanda LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $row = $stmt->fetch_assoc();   
            $res['motivo']   =   $row['motivo'];

            $stmt->close();
            return $res;
            
        }else{
            
            if( $usa_checkin == 'S' ){
                $stmt = $this->__bd->query( "SELECT checkin.cod_cli, checkin.nome_cli, checkin.data_nasc, checkin.telefone, checkin.email, clientes.cod_tipo_cliente, clientes.cnpj FROM checkin INNER JOIN clientes ON clientes.cod_cli = checkin.cod_cli WHERE num_comanda = $comanda;" );
                
                if( $stmt->num_rows > 0 ){
                    
                    $row = $stmt->fetch_assoc();
                    
                    $res2['cod_cli']            = $row['cod_cli'];
                    $res2['nome_cli']           = $row['nome_cli'];
                    $res2['data_nasc']          = $row['data_nasc'];
                    $res2['telefone']           = $row['telefone'];
                    $res2['email']              = $row['email'];
                    $res2['cod_tipo_cliente']   = $row['cod_tipo_cliente'];
                    $res2['cpf']                = $row['cnpj'];
                    
                    $res['checkin'] = $res2;
                    $res['motivo'] = 'vinculada';
                    
                    return $res;
                    
                }
                
            }
            
            return false;
            
        }
    }
    
    /**
     * Consulta de Itens da Comanda ou Mesa
     * @return array Array com os dados dos itens
     */
    protected $ListaDeConsultaItens = array();
    
    protected function consultaItens( $operacao, $comanda_mesa ){
        
        if( $operacao == "mesa" ){
            
            $condicao = " cod_mesa = $comanda_mesa ";
            
        }elseif( $operacao == "comanda" ){
            
            $condicao = " num_comanda = $comanda_mesa ";
            
        }
        
        $stmt = $this->__bd->query( "SELECT cod_reg, cod_item, descr_item, vlr_unit, qtde, vlr_total, posicao, transf, multi_sabor, ordem_lancamento, operador_subs, data_hora, nome_cliente FROM vendas_pendentes WHERE $condicao UNION SELECT '-1' as cod_reg, item_cancelado.cod_item, produtos.descr_item, preco_unit, qtde, (vlr_unit * qtde) as vlr_total, '0' as posicao, '0' as transf, 'N' as multi_sabor, '-2' as ordem_lancamento, 'N' as operador_subs, 'N' as data_hora, 'N' as nome_cliente FROM item_cancelado INNER JOIN produtos ON produtos.cod_item = item_cancelado.cod_item WHERE $condicao", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){
                
                $res['cod_reg']           =   $row['cod_reg'];
                $res['cod_item']          =   $row['cod_item'];
                $res['descr_item']        =   $row['descr_item'];
                $res['vlr_unit']          =   $row['vlr_unit'];
                $res['qtde']              =   $row['qtde'];
                $res['vlr_total']         =   $row['vlr_total'];
                $res['posicao']           =   $row['posicao'];
                $res['transf']            =   $row['transf'];
                $res['multi_sabor']       =   $row['multi_sabor'];
                $res['data_hora']         =   $row['data_hora'];
                $res['ordem_lancamento']  =   $row['ordem_lancamento'];
                $res['operador_subs']     =   $row['operador_subs'];
                $res['nome_cliente']      =   $row['nome_cliente'];
                
                $this->ListaDeConsultaItens[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDeConsultaItens;
            
        }else{
            
            $res = "";
            return $this->ListaDeConsultaItens;
            
        }
    }

    
    /**
     * Consulta de Cliente
     * @return array Array com os dados dos clientes
     */
    protected $DadosCliente = array();
    
    protected function consultaCliente( $numero, $tipo_consulta ){
        
        if( $tipo_consulta == 'telefone' ){
            $w = "telefone = $numero";
        }elseif( $tipo_consulta == 'cpf' ){
            $w = "cnpj = $numero";
        }
        
        $stmt = $this->__bd->query( "SELECT cod_cli, razao, fantasia, cnpj, insc_estadual,
        obs, e_mail, ddd, telefone, telefone_2, data_cadastro, tipo_pessoa, data_aniversario, 
        cod_tipo_cliente, cod_cpl, desconto, taxa_adicional, vlr_maior_compra, vlr_compras_acumuladas, 
        vlr_ultima_compra, qtde_vendas, saldo_pendura, obs_gerais, cod_endereco, sexo, limite_pendura
        FROM clientes WHERE $w LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $row = $stmt->fetch_array();

            $res['cod_cli']                =   $row['cod_cli'];
            $res['razao']                  =   $row['razao'];
            $res['fantasia']               =   $row['fantasia'];
            $res['cnpj']                   =   $row['cnpj'];
            $res['insc_estadual']          =   $row['insc_estadual'];
            $res['obs']                    =   $row['obs'];
            $res['e_mail']                 =   $row['e_mail'];
            $res['ddd']                    =   $row['ddd'];
            $res['telefone']               =   $row['telefone'];
            $res['telefone_2']             =   $row['telefone_2'];
            $res['data_cadastro']          =   $row['data_cadastro'];
            $res['tipo_pessoa']            =   $row['tipo_pessoa'];
            $res['data_aniversario']       =   $row['data_aniversario'];
            $res['cod_tipo_cliente']       =   $row['cod_tipo_cliente'];
            $res['cod_cpl']                =   $row['cod_cpl'];
            $res['desconto']               =   $row['desconto'];
            $res['taxa_adicional']         =   $row['taxa_adicional'];
            $res['vlr_maior_compra']       =   $row['vlr_maior_compra'];
            $res['vlr_compras_acumuladas'] =   $row['vlr_compras_acumuladas'];
            $res['vlr_ultima_compra']      =   $row['vlr_ultima_compra'];
            $res['qtde_vendas']            =   $row['qtde_vendas'];
            $res['saldo_pendura']          =   $row['saldo_pendura'];
            $res['obs_gerais']             =   $row['obs_gerais'];
            $res['cod_endereco']           =   $row['cod_endereco'];
            $res['sexo']                   =   $row['sexo'];
            $res['limite_pendura']         =   $row['limite_pendura'];

            $this->DadosCliente[] = $res;

            $stmt->close();
            return $this->DadosCliente;

        }else{
            return false;
        }

    }
    

    /**
     * Listagem do Mapa das Mesas
     * @return array Array com os dados de retorno do mapa das mesas
     */
    protected $MesasPreFechamento = array();
    protected $MesasEmUso = array();
    protected $MesasLivres = array();
    
    protected function mapaDeMesas(){
        
        $stmt = $this->__bd->query( "SELECT num_mesas FROM configuracao_loja LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $mesas = $stmt->fetch_array();
            $mesas = $mesas['num_mesas'];
            
            if($mesas > 0){
                
                $stmt->close();
                
                //pega todas as mesas em pre-fechamento
                $stmt = $this->__bd->query( "SELECT cod_mesa FROM vendas_pendentes WHERE cod_mesa > 0 AND flag_aberta = 'F'", MYSQLI_STORE_RESULT );
                
                if( $stmt->num_rows > 0 ){
                    
                    while( $row = $stmt->fetch_assoc() ){
                        $this->MesasPreFechamento[] = $row['cod_mesa'];
                    }
                    $stmt->close();
                    
                }
                    
                $stmt = $this->__bd->query( "SELECT cod_mesa FROM item_cancelado WHERE cod_mesa > 0 AND flag_aberta = 'F'", MYSQLI_STORE_RESULT );
                
                    if( $stmt->num_rows > 0 ){
                    
                    while( $row = $stmt->fetch_assoc() ){
                        $this->MesasPreFechamento[] = $row['cod_mesa'];
                    }
                    $stmt->close();
                }
                
                
                //pega todas as mesas em uso
                $stmt = $this->__bd->query( "SELECT cod_mesa FROM vendas_pendentes WHERE cod_mesa > 0 AND flag_aberta = 'S'", MYSQLI_STORE_RESULT );
                
                if( $stmt->num_rows > 0 ){
                    
                    while( $row = $stmt->fetch_assoc() ){
                        $this->MesasEmUso[] = $row['cod_mesa'];
                    }
                    $stmt->close();
                    
                }
                    
                $stmt = $this->__bd->query( "SELECT cod_mesa FROM item_cancelado WHERE cod_mesa > 0 AND flag_aberta = 'S'", MYSQLI_STORE_RESULT );
                
                if( $stmt->num_rows > 0 ){
                    
                    while( $row = $stmt->fetch_assoc() ){
                        $this->MesasEmUso[] = $row['cod_mesa'];
                    }
                    $stmt->close();
                }
                
                
                $mesa = array();
                $lista_mesas = array();
                
                //corre todas as mesas, verifica os status e atribui a suas respectivas variáveis
                for( $i = 1; $i <= $mesas; $i++ ){

                   if( in_array( $i, $this->MesasPreFechamento ) ){
                       
                       $mesa['num'] = $i;
                       $mesa['status'] = 'Fechando';
                       
                   }elseif( in_array( $i, $this->MesasEmUso ) ){
                       
                       $mesa['num'] = $i;
                       $mesa['status'] = 'EmUso';
                       
                   }else{
                       
                       $mesa['num'] = $i;
                       $mesa['status'] = 'Livre';
                   }
                   
                   $lista_mesas[] = $mesa;
                    
                }

                return $lista_mesas;
                
            }else{
                return false;
            }
        }else{
            return false;
        }
    }
    
    /**
     * Lista a quantidade de mesas, inclusive traz a imagem do logo da loja
     * @return array Array com a quantidade de mesas que a loja trabalha
     */
    protected function qtdMesas(){
        
        $stmt = $this->__bd->query( "SELECT num_mesas, url_imagem_logo FROM configuracao_loja LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $mesas = $stmt->fetch_array();
            $res['qtd_mesas'] = $mesas['num_mesas'];
            $res['url_imagem_logo'] = $mesas['url_imagem_logo'];

            return $res;
        }else{
            return false;
        }

    }


    /**
     * Listagem do Mapa das Comandas
     * @return array Array com os dados de retorno do mapa das comandas
     */
    protected $ComandasBloqueadas = array();
    protected $ComandasEmUso = array();
    protected $ComandasLivres = array();
    protected $ComandasBloqueadasMotivo = array();
    
    protected function mapaDeComandas(){
        
        $stmt = $this->__bd->query( "SELECT num_comanda, comanda_ini FROM numeros LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $comandas = $stmt->fetch_array();
            $comandas_ini = $comandas['comanda_ini'];
            $comandas_max = $comandas['num_comanda'];
            
            if( $comandas_max > 0 ){
                
                $stmt->close();
                
                //pega todas as comandas bloqueadas
                $stmt = $this->__bd->query( "SELECT num_comanda, motivo FROM comanda_bloq WHERE num_comanda > 0", MYSQLI_STORE_RESULT );
                
                if( $stmt->num_rows > 0 ){
                    
                    while( $row = $stmt->fetch_assoc() ){
                        $this->ComandasBloqueadas[] = $row['num_comanda'];
                        $this->ComandasBloqueadasMotivo[$row['num_comanda']]['motivo'] = $row['motivo'];
                    }
                    $stmt->close();
                
                }
                
                //pega todas as comandas em uso
                $stmt = $this->__bd->query( "SELECT num_comanda FROM vendas_pendentes WHERE num_comanda > 0", MYSQLI_STORE_RESULT );
                
                if( $stmt->num_rows > 0 ){
                    
                    while( $row = $stmt->fetch_assoc() ){
                        $this->ComandasEmUso[] = $row['num_comanda'];
                    }
                    $stmt->close();
                    
                }
                    
                  
                $stmt = $this->__bd->query( "SELECT num_comanda FROM item_cancelado WHERE num_comanda > 0", MYSQLI_STORE_RESULT );
                
                if( $stmt->num_rows > 0 ){
                    
                    while( $row = $stmt->fetch_assoc() ){
                        $this->ComandasEmUso[] = $row['num_comanda'];
                    }
                    $stmt->close();
                }
                
                
                $comanda = array();
                $lista_comandas = array();
                
                //corre todas as comandas a partir da comanda inicial, verifica os status e atribui a suas respectivas variáveis
                for( $i = $comandas_ini; $i <= $comandas_max; $i++ ){

                   if( in_array( $i, $this->ComandasBloqueadas ) ){
                       
                       $comanda['num'] = $i;
                       $comanda['status'] = 'Bloqueada';
                       $comanda['motivo'] = $this->ComandasBloqueadasMotivo[$i]['motivo'];
                       
                   }elseif( in_array( $i, $this->ComandasEmUso ) ){
                       
                       $comanda['num'] = $i;
                       $comanda['status'] = 'EmUso';
                       $comanda['motivo'] = '';
                       
                   }else{
                       
                       $comanda['num'] = $i;
                       $comanda['status'] = 'Livre';
                       $comanda['motivo'] = '';
                   }
                   
                   $lista_comandas[] = $comanda;
                    
                }

                return $lista_comandas;
                
            }else{
                return false;
            }
        }else{
            return false;
        }
    }

    /**
     * Lista a quantidade de comandas
     * @return array Array com a quantidade de comandas que a loja trabalha
     */
    protected function qtdComandas(){
        
        $stmt = $this->__bd->query( "SELECT comanda_ini, num_comanda FROM numeros LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $comandas = $stmt->fetch_array();
            $res['comandas_min'] = $comandas['comanda_ini'];
            $res['comandas_max'] = $comandas['num_comanda'];

            return $res;
        }else{
            return false;
        }

    }


    /**
     * Captura a o código de rede e loja 
     * @return array Array com o código de rede e o código de loja
     */
    protected function capturaRedeLoja(){
        
        $stmt = $this->__bd->query( "SELECT cod_loja FROM configuracao_loja LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $retorno = $stmt->fetch_array();
            $res['codigo_loja'] = $retorno['cod_loja'];

        }else{
            return false;
        }

        $stmt->close();

        $stmt = $this->__bd->query( "SELECT cod_rede FROM parametros LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $retorno = $stmt->fetch_array();
            $res['codigo_rede'] = $retorno['cod_rede'];

        }else{
            return false;
        }

        return $res;
    }


    /**
     * Captura os dados referentes ao uso da integração com Mercado Pago
     * @return array Array com os dados de Mercado Pago
     */
    protected function dadosMercadoPago(){
        
        $stmt = $this->__bd->query( "SELECT usa_mercado_pago, token_mercado_pago, store_id_mercado_pago FROM configuracao_loja LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $retorno = $stmt->fetch_array();
            $res['usa_mercado_pago'] = $retorno['usa_mercado_pago'];
            $res['token_mercado_pago'] = $retorno['token_mercado_pago'];
            $res['store_id_mercado_pago'] = $retorno['store_id_mercado_pago'];

        }else{
            return false;
        }

        $stmt->close();

        return $res;
    }


    /**
     * Captura os dados referentes ao uso da integração com a Shipay(carteira digital)
     * @return array Array com os dados da Shipay
     */
    protected function dadosShipay(){
        
        $stmt = $this->__bd->query( "SELECT usa_shipay, access_key_shipay, secret_key_shipay, cpf_cnpj_shipay FROM configuracao_loja LIMIT 1", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            $retorno = $stmt->fetch_array();
            $res['usa_shipay'] = $retorno['usa_shipay'];
            $res['access_key_shipay'] = $retorno['access_key_shipay'];
            $res['secret_key_shipay'] = $retorno['secret_key_shipay'];
            $res['cpf_cnpj_shipay'] = $retorno['cpf_cnpj_shipay'];

        }else{
            return false;
        }

        $stmt->close();

        return $res;
    }

    
    /**
     * Lista todos os Grupos cadastrados no estabelecimento com base na carga seletiva, se não houver traz todos os grupos normalmente
     * @return array Array com a lista de grupos vindos da base
     */
    protected $ListaDeGrupos = array();
    protected $ListaDeSubGrupos = array();
    
    protected function listaGrupos( $numero_pocket ){
        
        /*
         * Faz SELECT olhando carga seletiva do pocket
         */
        $stmt = $this->__bd->query( "SELECT grupos.cod_grupo, descr_grupo, cor_grupo, porc_desc, valor_f, valor_i, descr_eua, descr_esp, descr_bra, grupos.imagem, grupos.ordem_touch, grupos.url_imagem_od FROM grupos INNER JOIN produtos ON produtos.cod_grupo = grupos.cod_grupo INNER JOIN cargaseletiva_pocket ON cargaseletiva_pocket.cod_grupo = grupos.cod_grupo WHERE cargaseletiva_pocket.num_pocket = $numero_pocket AND produtos.status_item NOT IN('V','S') GROUP BY grupos.descr_grupo", MYSQLI_STORE_RESULT );

        
        
        if( $stmt->num_rows == 0 ){
            
            /*
             * Se não encontrar nada na carga seletiva faz SELECT de todos os grupos
             */
            $stmt = $this->__bd->query( "SELECT grupos.cod_grupo, descr_grupo, cor_grupo, porc_desc, valor_f, valor_i, descr_eua, descr_esp, descr_bra, grupos.imagem, grupos.ordem_touch, grupos.url_imagem_od FROM grupos INNER JOIN produtos ON produtos.cod_grupo = grupos.cod_grupo WHERE grupos.cod_grupo IS NOT NULL AND produtos.status_item NOT IN('V','S') GROUP BY grupos.descr_grupo", MYSQLI_STORE_RESULT );

            
        }
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                if( strlen( $row['cor_grupo'] ) == 0 ){
                    $row['cor_grupo'] = "255, 255, 255";
                }

                $cores = $this->rgbToHexAndContrast( $row['cor_grupo'] );
                
                $res['cod_grupo']     =   $row['cod_grupo'];
                $res['descr_grupo']   =   $row['descr_grupo'];
                $res['cor_grupo']     =   $cores['hex'];
                $res['cor_fonte']     =   $cores['fonte_hex'];
                $res['porc_desc']     =   $row['porc_desc'];
                $res['valor_f']       =   $row['valor_f'];
                $res['valor_i']       =   $row['valor_i'];
                $res['descr_eua']     =   $row['descr_eua'];
                $res['descr_esp']     =   $row['descr_esp'];
                $res['descr_bra']     =   $row['descr_bra'];
                $res['ordem_touch']   =   $row['ordem_touch'];
                $res['url_imagem_od'] =   $row['url_imagem_od'];
                $res['imagem']        =   base64_encode( $row['imagem'] );
                
                $this->ListaDeGrupos[] = $res;

            }
            
            $stmt->close();
            
            $resposta['grupos'] = $this->ListaDeGrupos;
            
            $stmt = $this->__bd->query( "SELECT DISTINCT sub_grupos.descricao, produtos.cod_grupo, sub_grupos.cod_sub_grupo FROM sub_grupos LEFT JOIN produtos ON produtos.cod_sub_grupo = sub_grupos.cod_sub_grupo WHERE NOT ISNULL(sub_grupos.cod_sub_grupo)", MYSQLI_STORE_RESULT );
            
            if( $stmt->num_rows > 0 ){
                
                while( $row = $stmt->fetch_assoc() ){

                    $res2['cod_sub_grupo']   =   $row['cod_sub_grupo'];
                    $res2['cod_grupo']       =   $row['cod_grupo'];
                    $res2['descricao']       =   $row['descricao'];

                    $this->ListaDeSubGrupos[] = $res2;

                }
                
                $stmt->close();
            
                $resposta['subgrupos'] = $this->ListaDeSubGrupos;
            }else{
                $resposta['subgrupos'] = "";
            }
            
            return $resposta;
            
        }else{
            
            return false;
            
        }
        
    }
    
    
    /**
     * Lista todos os Produtos cadastrados no estabelecimento
     * @return array Array com a lista de produtos vindo da base da loja
     */
    protected $ListaDeProdutos = array();
    
    protected function listaProdutos( $numero_pocket=9999 ){

        //Procura o parametro específico ListarProdutosAtendimentoLojaDispositivosMoveis para filtrar os produtos por INDOOR
        $stmt = $this->__bd->query( "SELECT cod_param FROM parametros_especificos WHERE nome_acesso = 'ListarProdutosAtendimentoLojaDispositivosMoveis' LIMIT 1", MYSQLI_STORE_RESULT );
        $filtro_indoor = '';
        if( $stmt->num_rows > 0 ){
            $filtro_indoor = ' AND produtos.service_open_delivery LIKE "%INDOOR%" ';
        }
        $stmt->close();

        //SELECT para verificar se ha carga seletiva
        $stmt = $this->__bd->query( "SELECT produtos.cod_item, produtos.cod_grupo, produtos.descr_item, produtos.vlr_unit, produtos.multi_sabores, produtos.combo, produtos.adicional_delivery, produtos.status_item, produtos.cod_unid, produtos.cor_produto, produtos.resumo_web, produtos.impressao1, produtos.impressao2, produtos.cod_sub_grupo, produtos.observacao, grupos.descr_grupo, sub_grupos.descricao as nome_sub_grupo, produtos.ordem_touch, produtos.imagem, produtos.produto_pizza, produtos.isento_desconto, produtos.cod_grupo_web, produtos.descricao_web, produtos.info_extra_web, produtos.qtde_calorica, produtos.info_nutricional, produtos.service_open_delivery, produtos.url_imagem_od, produtos.cod_grupo_sugerido FROM produtos INNER JOIN grupos ON grupos.cod_grupo = produtos.cod_grupo LEFT JOIN sub_grupos ON sub_grupos.cod_sub_grupo = produtos.cod_sub_grupo LEFT JOIN cargaseletiva_pocket ON grupos.cod_grupo = cargaseletiva_pocket.cod_grupo WHERE produtos.status_item != 'S' AND cargaseletiva_pocket.num_pocket = ".$numero_pocket." ". $filtro_indoor, MYSQLI_STORE_RESULT );
        
        
        if( $stmt->num_rows == 0 ){
        
            $stmt = $this->__bd->query( "SELECT produtos.cod_item, produtos.cod_grupo, produtos.descr_item, produtos.vlr_unit, produtos.multi_sabores, produtos.combo, produtos.adicional_delivery, produtos.status_item, produtos.cod_unid, produtos.cor_produto, produtos.resumo_web, produtos.impressao1, produtos.impressao2, produtos.cod_sub_grupo, produtos.observacao, grupos.descr_grupo, sub_grupos.descricao as nome_sub_grupo, produtos.ordem_touch, produtos.imagem, produtos.produto_pizza, produtos.isento_desconto, produtos.cod_grupo_web, produtos.descricao_web, produtos.info_extra_web, produtos.qtde_calorica, produtos.info_nutricional, produtos.service_open_delivery, produtos.url_imagem_od, produtos.cod_grupo_sugerido FROM produtos INNER JOIN grupos ON grupos.cod_grupo = produtos.cod_grupo LEFT JOIN sub_grupos ON sub_grupos.cod_sub_grupo = produtos.cod_sub_grupo WHERE produtos.status_item != 'S'". $filtro_indoor, MYSQLI_STORE_RESULT );

        }
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){
                
                if( strlen( $row['cor_produto'] ) == 0 ){
                    $row['cor_produto'] = "255, 255, 255";
                }

                $cores = $this->rgbToHexAndContrast( $row['cor_produto'] );

                $res['cod_item']            =   $row['cod_item'];
                $res['cod_grupo']           =   $row['cod_grupo'];
                $res['descr_grupo']         =   $row['descr_grupo'];
                $res['cor_produto']         =   $cores['hex'];
                $res['cor_fonte']           =   $cores['fonte_hex'];
                $res['descr_item']          =   $row['descr_item'];
                $res['resumo_web']          =   $row['resumo_web'];

                if( $row['observacao'] == 1 ){
                    $res['vlr_unit'] = 0;
                }else{
                    $res['vlr_unit'] = $row['vlr_unit'];
                }
                
                $res['observacao']              =   $row['observacao'];
                $res['combo']                   =   $row['combo'];
                $res['multi_sabores']           =   $row['multi_sabores'];
                $res['adicional_delivery']      =   $row['adicional_delivery'];
                $res['status_item']             =   $row['status_item'];
                $res['cod_unid']                =   $row['cod_unid'];
                $res['impressao1']              =   $row['impressao1'];
                $res['impressao2']              =   $row['impressao2'];
                $res['cod_sub_grupo']           =   $row['cod_sub_grupo'];
                $res['nome_sub_grupo']          =   $row['nome_sub_grupo'];
                $res['ordem_touch']             =   $row['ordem_touch'];
                $res['imagem']                  =   $row['imagem'];
                $res['produto_pizza']           =   $row['produto_pizza'];
                $res['isento_desconto']         =   $row['isento_desconto'];

                //Dados incluidos em 08/2023
                $res['cod_grupo_web']           =   $row['cod_grupo_web'];
                $res['descricao_web']           =   $row['descricao_web'];
                $res['info_extra_web']          =   $row['info_extra_web'];
                $res['qtde_calorica']           =   $row['qtde_calorica'];
                $res['info_nutricional']        =   $row['info_nutricional'];
                $res['service_open_delivery']   =   $row['service_open_delivery'];
                $res['url_imagem_od']           =   $row['url_imagem_od'];

                $res['cod_grupo_sugerido']      =   $row['cod_grupo_sugerido'];
                
                $this->ListaDeProdutos[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDeProdutos;
            
        }else{
            
            return false;
            
        }
        
    }



    /**
     * Lista todos os Produtos Escondidos cadastrados no estabelecimento
     * @return array Array com a lista de produtos vindo da base da loja
     */
    protected $ListaDeProdutosEscondidos = array();
    
    protected function listaProdutosEscondidos( $numero_pocket=9999 ){

        //Procura o parametro específico ListarProdutosAtendimentoLojaDispositivosMoveis para filtrar os produtos por INDOOR
        $stmt = $this->__bd->query( "SELECT cod_param FROM parametros_especificos WHERE nome_acesso = 'ListarProdutosAtendimentoLojaDispositivosMoveis' LIMIT 1", MYSQLI_STORE_RESULT );
        $filtro_indoor = '';
        if( $stmt->num_rows > 0 ){
            $filtro_indoor = ' AND produtos.service_open_delivery LIKE "%INDOOR%" ';
        }
        $stmt->close();

        //SELECT para verificar se ha carga seletiva
        $stmt = $this->__bd->query( "SELECT produtos.cod_item, produtos.cod_grupo, produtos.descr_item, produtos.vlr_unit, produtos.multi_sabores, produtos.combo, produtos.adicional_delivery, produtos.status_item, produtos.cod_unid, produtos.cor_produto, produtos.resumo_web, produtos.impressao1, produtos.impressao2, produtos.cod_sub_grupo, produtos.observacao, grupos.descr_grupo, sub_grupos.descricao as nome_sub_grupo, produtos.ordem_touch, produtos.imagem, produtos.produto_pizza, produtos.isento_desconto, produtos.cod_grupo_web, produtos.descricao_web, produtos.info_extra_web, produtos.qtde_calorica, produtos.info_nutricional, produtos.service_open_delivery, produtos.url_imagem_od FROM produtos INNER JOIN grupos ON grupos.cod_grupo = produtos.cod_grupo LEFT JOIN sub_grupos ON sub_grupos.cod_sub_grupo = produtos.cod_sub_grupo LEFT JOIN cargaseletiva_pocket ON grupos.cod_grupo = cargaseletiva_pocket.cod_grupo WHERE produtos.status_item = 'S' AND cargaseletiva_pocket.num_pocket = ".$numero_pocket." ". $filtro_indoor, MYSQLI_STORE_RESULT );
        
        
        if( $stmt->num_rows == 0 ){
        
            $stmt = $this->__bd->query( "SELECT produtos.cod_item, produtos.cod_grupo, produtos.descr_item, produtos.vlr_unit, produtos.multi_sabores, produtos.combo, produtos.adicional_delivery, produtos.status_item, produtos.cod_unid, produtos.cor_produto, produtos.resumo_web, produtos.impressao1, produtos.impressao2, produtos.cod_sub_grupo, produtos.observacao, grupos.descr_grupo, sub_grupos.descricao as nome_sub_grupo, produtos.ordem_touch, produtos.imagem, produtos.produto_pizza, produtos.isento_desconto, produtos.cod_grupo_web, produtos.descricao_web, produtos.info_extra_web, produtos.qtde_calorica, produtos.info_nutricional, produtos.service_open_delivery, produtos.url_imagem_od FROM produtos INNER JOIN grupos ON grupos.cod_grupo = produtos.cod_grupo LEFT JOIN sub_grupos ON sub_grupos.cod_sub_grupo = produtos.cod_sub_grupo WHERE produtos.status_item = 'S'". $filtro_indoor, MYSQLI_STORE_RESULT );

        }
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){
                
                if( strlen( $row['cor_produto'] ) == 0 ){
                    $row['cor_produto'] = "255, 255, 255";
                }

                $cores = $this->rgbToHexAndContrast( $row['cor_produto'] );

                $res['cod_item']            =   $row['cod_item'];
                $res['cod_grupo']           =   $row['cod_grupo'];
                $res['descr_grupo']         =   $row['descr_grupo'];
                $res['cor_produto']         =   $cores['hex'];
                $res['cor_fonte']           =   $cores['fonte_hex'];
                $res['descr_item']          =   $row['descr_item'];
                $res['resumo_web']          =   $row['resumo_web'];

                if( $row['observacao'] == 1 ){
                    $res['vlr_unit'] = 0;
                }else{
                    $res['vlr_unit'] = $row['vlr_unit'];
                }
                
                $res['observacao']              =   $row['observacao'];
                $res['combo']                   =   $row['combo'];
                $res['multi_sabores']           =   $row['multi_sabores'];
                $res['adicional_delivery']      =   $row['adicional_delivery'];
                $res['status_item']             =   $row['status_item'];
                $res['cod_unid']                =   $row['cod_unid'];
                $res['impressao1']              =   $row['impressao1'];
                $res['impressao2']              =   $row['impressao2'];
                $res['cod_sub_grupo']           =   $row['cod_sub_grupo'];
                $res['nome_sub_grupo']          =   $row['nome_sub_grupo'];
                $res['ordem_touch']             =   $row['ordem_touch'];
                $res['imagem']                  =   $row['imagem'];
                $res['produto_pizza']           =   $row['produto_pizza'];
                $res['isento_desconto']         =   $row['isento_desconto'];

                //Dados incluidos em 08/2023
                $res['cod_grupo_web']           =   $row['cod_grupo_web'];
                $res['descricao_web']           =   $row['descricao_web'];
                $res['info_extra_web']          =   $row['info_extra_web'];
                $res['qtde_calorica']           =   $row['qtde_calorica'];
                $res['info_nutricional']        =   $row['info_nutricional'];
                $res['service_open_delivery']   =   $row['service_open_delivery'];
                $res['url_imagem_od']           =   $row['url_imagem_od'];
                
                $this->ListaDeProdutosEscondidos[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDeProdutosEscondidos;
            
        }else{
            
            return false;
            
        }
        
    }
    
    
    /**
     * Lista todos os Combos cadastrados no estabelecimento
     * @return array Lista com os combos cadastrados na loja
     */
    protected $ListaDeCombos = array();
    
    protected function listaCombos(){

        //Procura o parametro específico ListarProdutosAtendimentoLojaDispositivosMoveis para filtrar os produtos por INDOOR
        $stmt = $this->__bd->query( "SELECT cod_param FROM parametros_especificos WHERE nome_acesso = 'ListarProdutosAtendimentoLojaDispositivosMoveis' LIMIT 1", MYSQLI_STORE_RESULT );
        $filtro_indoor = '';
        if( $stmt->num_rows > 0 ){
            $filtro_indoor = ' AND produtos.service_open_delivery LIKE "%INDOOR%" ';
        }
        $stmt->close();
        
        $stmt = $this->__bd->query( "SELECT combo.cod_prod_princ, combo.cod_prod_vinc, combo.qtde_obrig, combo.preco_diferenciado, combo.vlr_unit as vlr_unit_combo, combo.combo_princ, combo.qtde_max, combo.nome_nivel, combo.etapa, combo.qtde_min_obrig, combo.qtde_max_item, produtos.descr_item, produtos.vlr_unit as vlr_unit_prod, produtos.cor_produto, produtos.impressao1, produtos.impressao2, produtos.observacao, produtos.ordem_touch FROM combo INNER JOIN produtos ON produtos.cod_item = combo.cod_prod_vinc WHERE produtos.status_item != 'S'". $filtro_indoor." ORDER BY combo.cod_prod_princ ASC, combo.combo_princ DESC", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){
                
                if( strlen( $row['cor_produto'] ) == 0 ){
                    $row['cor_produto'] = "255, 255, 255";
                }
                
                $cores = $this->rgbToHexAndContrast( $row['cor_produto'] );

                $res['cod_prod_princ']      =   $row['cod_prod_princ'];
                $res['cod_prod_vinc']       =   $row['cod_prod_vinc'];
                $res['qtde_obrig']          =   $row['qtde_obrig'];
                $res['cor_combo']           =   $cores['hex'];
                $res['cor_fonte']           =   $cores['fonte_hex'];
                $res['descr_item']          =   $row['descr_item'];

                if( $row['observacao'] == 1 ){
                    $res['vlr_unit_prod'] = 0;
                }else{
                    $res['vlr_unit_prod'] = $row['vlr_unit_prod'];
                }

                $res['observacao']          =   $row['observacao'];
                $res['preco_diferenciado']  =   $row['preco_diferenciado'];
                $res['vlr_unit_combo']      =   $row['vlr_unit_combo'];
                $res['combo_princ']         =   $row['combo_princ'];
                $res['qtde_max']            =   $row['qtde_max'];
                $res['nome_nivel']          =   $row['nome_nivel'];
                $res['impressao1']          =   $row['impressao1'];
                $res['impressao2']          =   $row['impressao2'];
                $res['ordem_touch']         =   $row['ordem_touch'];
                $res['etapa']               =   $row['etapa'];
                $res['qtde_min_obrig']      =   $row['qtde_min_obrig'];
                $res['qtde_max_item']       =   $row['qtde_max_item'];
                
                $this->ListaDeCombos[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDeCombos;
            
        }else{
            
            return false;
            
        }
        
    }




    /**
     * Lista todas as imagens de banners da loja se houver
     * @return array Lista com as URLs das imagens no FTP do PedidosWEB
     */
    protected $ListaDeBanners = array();
    
    protected function listaBanners(){
        
        $stmt = $this->__bd->query( "SELECT id_imagem, cod_loja, nome_arquivo, url, ordem, tipo, data_criacao FROM imagens_totem ORDER BY ordem", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['id_imagem']      =   $row['id_imagem'];
                $res['cod_loja']       =   $row['cod_loja'];
                $res['nome_arquivo']   =   $row['nome_arquivo'];
                $res['url']            =   $row['url'];
                $res['ordem']          =   $row['ordem'];
                $res['tipo']           =   $row['tipo'];
                $res['data_criacao']   =   $row['data_criacao'];

                
                $this->ListaDeBanners[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDeBanners;
            
        }else{
            
            return false;
            
        }
        
    }


    /**
     * Lista todos os produtos Pizza, configuracoes cadastrados no estabelecimento
     * @return array Lista com os produtos Pizza cadastrados na loja
     */
    protected $ListaConfigPizzas   = array();
    protected $ListaSaboresPizzas  = array();
    protected $ListaOpcionaisPizza = array();
    
    protected function listaPizzas(){

        //Procura o parametro específico ListarProdutosAtendimentoLojaDispositivosMoveis para filtrar os produtos por INDOOR
        $stmt = $this->__bd->query( "SELECT cod_param FROM parametros_especificos WHERE nome_acesso = 'ListarProdutosAtendimentoLojaDispositivosMoveis' LIMIT 1", MYSQLI_STORE_RESULT );
        $filtro_indoor = '';
        if( $stmt->num_rows > 0 ){
            $filtro_indoor = ' WHERE produtos.service_open_delivery LIKE "%INDOOR%" ';
        }
        $stmt->close();
        
        $stmt = $this->__bd->query( "SELECT configuracao_pizzas.cod_item_pizza, configuracao_pizzas.num_sabores, configuracao_pizzas.usa_preco_principal FROM configuracao_pizzas INNER JOIN produtos ON configuracao_pizzas.cod_item_pizza = produtos.cod_item" . $filtro_indoor . "" , MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['cod_item_pizza']      =   $row['cod_item_pizza'];
                $res['num_sabores']         =   $row['num_sabores'];
                $res['usa_preco_principal'] =   $row['usa_preco_principal'];
                
                $this->ListaConfigPizzas[] = $res;

            }

            
            $stmt->close();
            
            $resposta['configuracao_pizzas'] = $this->ListaConfigPizzas;
            
            $stmt = $this->__bd->query( "SELECT sabores_pizza.cod_item_pizza, sabores_pizza.cod_item, sabores_pizza.tipo FROM sabores_pizza INNER JOIN produtos ON sabores_pizza.cod_item_pizza = produtos.cod_item" . $filtro_indoor . "" , MYSQLI_STORE_RESULT );
            
            if( $stmt->num_rows > 0 ){
                
                while( $row = $stmt->fetch_assoc() ){

                    $res2['cod_item_pizza']   =   $row['cod_item_pizza'];
                    $res2['cod_item']         =   $row['cod_item'];
                    $res2['tipo']             =   $row['tipo'];

                    $this->ListaSaboresPizzas[] = $res2;

                }
            
                $resposta['sabores_pizzas'] = $this->ListaSaboresPizzas;
            }else{
                $resposta['sabores_pizzas'] = "";
            }
            
            $stmt->close();

            $stmt = $this->__bd->query( "SELECT opcionais_pizza.cod_item_sabor, opcionais_pizza.cod_item, opcionais_pizza.preco_diferenciado, opcionais_pizza.vlr_unit FROM opcionais_pizza INNER JOIN produtos ON opcionais_pizza.cod_item_sabor = produtos.cod_item" . $filtro_indoor . "", MYSQLI_STORE_RESULT );
            
            if( $stmt->num_rows > 0 ){
                
                while( $row = $stmt->fetch_assoc() ){

                    $res3['cod_item_sabor']     =   $row['cod_item_sabor'];
                    $res3['cod_item']           =   $row['cod_item'];
                    $res3['preco_diferenciado'] =   $row['preco_diferenciado'];

                    $this->ListaOpcionaisPizzas[] = $res3;
                }
            
                $resposta['opcionais_pizzas'] = $this->ListaOpcionaisPizzas;
            }else{
                $resposta['opcionais_pizzas'] = "";
            }


            return $resposta;
            
        }else{
            
            return false;
            
        }
        
    }
    
    
    /**
     * Lista todos os tipos de clientes cadastrados no estabelecimento
     * @return array Lista com os tipos de clientes cadastrados na loja
     */
    protected $ListaTipoClientes = array();
    
    protected function listaTipoClientes(){
        
        $stmt = $this->__bd->query( "SELECT cod_tipo_cliente, descricao FROM tipo_clientes ORDER BY descricao", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['cod_tipo_cliente']      =   $row['cod_tipo_cliente'];
                $res['descricao']             =   $row['descricao'];
                
                $this->ListaTipoClientes[] = $res;

            }
            
            $stmt->close();
            return $this->ListaTipoClientes;
            
        }else{
            
            return false;
            
        }
        
    }
    
    
    /**
     * Lista todos os Produtos Faltantes cadastrados no estabelecimento
     * @return array Lista dos produtos faltantes da loja
     */
    protected $ListaDeProdutosFaltantes = array();
    
    protected function listaProdutosFaltantes(){
        
        $stmt = $this->__bd->query( "SELECT cod_item, descricao FROM produtos_faltantes", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['cod_item']      =   $row['cod_item'];
                $res['descricao']     =   $row['descricao'];
                
                $this->ListaDeProdutosFaltantes[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDeProdutosFaltantes;
            
        }else{
            
            return false;
            
        }
        
    }
    
    
    /**
     * Lista todas as Promoções cadastradas no estabelecimento
     * @return array Lista com todas as promoções cadastradas na loja
     */
    protected $ListaDePromocoes = array();
    
    protected function listaPromocoes(){
        
        
        $stmt = $this->__bd->query( "SELECT prioridade, cod_item, perc_desc , data_ini_desc, data_fim_desc, dias_semana FROM promocao ORDER BY cod_item, prioridade", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['prioridade']      =   $row['prioridade'];
                $res['cod_item']        =   $row['cod_item'];
                $res['perc_desc']       =   $row['perc_desc'];
                $res['data_ini_desc']   =   $row['data_ini_desc'];
                $res['data_fim_desc']   =   $row['data_fim_desc'];
                $res['dias_semana']     =   $row['dias_semana'];
                
                
                $this->ListaDePromocoes[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDePromocoes;
            
        }else{
            
            return false;
            
        }
        
    }
    
    /**
     * Lista todas os MultiPrecos cadastradas no estabelecimento
     * @return array Lista com todas os multipreços cadastradas na loja
     */
    protected $ListaDeMultiPreco = array();
    
    protected function listaMultiPreco(){
        
        
        // $stmt = $this->__bd->query( "SELECT cod_item, cod_tipo, vlr_unit 
        //                                 FROM tabela_preco 
        //                                     ORDER BY cod_item", 
        //                             MYSQLI_STORE_RESULT );

        $stmt = $this->__bd->query("SELECT tab.cod_item, tab.cod_tipo, tab.vlr_unit, tip.descricao 
                                        FROM tabela_preco AS tab 
                                            INNER JOIN tipo_preco AS tip 
                                                ON tab.cod_tipo = tip.cod_tipo ");
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['cod_item']  =   $row['cod_item'];
                $res['cod_tipo']  =   $row['cod_tipo'];
                $res['vlr_unit']  =   $row['vlr_unit'];                
                $res['descricao'] =   $row['descricao'];                
                
                $this->ListaDeMultiPreco[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDeMultiPreco;
            
        }else{
            
            return false;
            
        }
        
    }
    
    /**
     * Lista todas os Detalhes de Bandeira cadastrados no estabelecimento
     * @return array Lista com todas os detalhes de bandeira cadastrados na loja
     */
    protected $ListaDeBandeiras = array();
    
    protected function listaDetalheBandeiras(){
        
        
        $stmt = $this->__bd->query( "SELECT tipo_det, cod_det, descr_det, c_magnus, chama_tef, cod_sitef, nome_imagem, imagem, ordem_bandeira FROM detalhe WHERE ativa='S' AND exibe_egarcom = 'S' ORDER BY ordem_bandeira, descr_det", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['tipo_det']       =   $row['tipo_det'];
                $res['cod_det']        =   $row['cod_det'];
                $res['descr_det']      =   $row['descr_det'];
                $res['c_magnus']       =   $row['c_magnus'];
                $res['chama_tef']      =   $row['chama_tef'];
                $res['cod_sitef']      =   $row['cod_sitef'];
                $res['nome_imagem']    =   $row['nome_imagem'];
                $res['imagem']         =   $row['imagem'];
                $res['ordem_bandeira'] =   $row['ordem_bandeira'];
                
                $this->ListaDeBandeiras[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDeBandeiras;
            
        }else{
            
            return false;
            
        }
        
    }
    
    
    /**
     * Lista todos os Vinculos de Produtos cadastrados no estabelecimento
     * @return array Lista com todas od vínculos de produtos cadastrados na loja
     */
    protected $ListaDeVinculos = array();
    
    protected function listaProdutosVinculados(){
        
        
        $stmt = $this->__bd->query( "SELECT cod_item, cod_item_vinc , vlr_unit, preco_diferenciado FROM vinculo_prod ORDER BY cod_item", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['cod_item']             =   $row['cod_item'];
                $res['cod_item_vinc']        =   $row['cod_item_vinc'];
                $res['vlr_unit']             =   $row['vlr_unit'];
                $res['preco_diferenciado']   =   $row['preco_diferenciado'];
                
                $this->ListaDeVinculos[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDeVinculos;
            
        }else{
            
            return false;
            
        }
        
    }
    

    
    /**
     * Lista todos os Vinculos de Produtos cadastrados no estabelecimento
     * @return array Lista com todas od vínculos de produtos cadastrados na loja
     */
    protected $ListaDeProdutosTemporarios = array();
    
    protected function listaProdutosTemporarios(){
        
        
        $stmt = $this->__bd->query( "SELECT * FROM produtos_temporarios", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['prioridade']             =   $row['prioridade'];
                $res['cod_item']        =   $row['cod_item'];
                $res['data_ini_indisp']             =   $row['data_ini_indisp'];
                $res['data_fim_indisp']   =   $row['data_fim_indisp'];
                $res['dias_semana']   =   $row['dias_semana'];
                
                $this->ListaDeProdutosTemporarios[] = $res;

            }
            
            $stmt->close();
            return $this->ListaDeProdutosTemporarios;
            
        }else{
            
            return false;
            
        }
        
    }
    
    
    /**
     * Lista todos os Operadores (garçons) que trabalham no estabelecimento
     * @param string $operacao Variável que indica qual é a operação, comanda ou mesa
     * @return array Lista com todos os operadores que trabalham no estabelecimento
     */
    protected $ListaDeOperadores = array();
    
    protected function listaOperadores( $operacao = "mesa" ){
        
        /**
         * Se operacao for mesa traz os garçons, do contrário traz os atendentes(vendedores)
         */
        if( $operacao == "comanda" ){
            
            $filtro = 'funcionarios.tipo_func = 2';
            
        }else if( $operacao == "mesa" ){
            
            $filtro = 'funcionarios.tipo_func = 3';
            
        }

        $stmt = $this->__bd->query( "SELECT funcionarios.cod_fun, funcionarios.razao, usuario_senha.senha FROM funcionarios 
                 INNER JOIN usuario_senha ON usuario_senha.cod_fun = funcionarios.cod_fun 
                 WHERE $filtro AND funcionarios.aliq_iss <> ''", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['cod_fun']     =   $row['cod_fun'];
                $res['nome_login']  =   mb_strtoupper( $row['razao'], 'UTF-8' );
                $res['senha']       =   base64_decode( $row['senha'] );
                
                //Faz consulta aos acessos do operador
                $stmt2 = $this->__bd->query( "SELECT cod_fun FROM usuario_modulos WHERE atalho = 'CancelarPedidoDispositivosMoveis' AND cod_fun = ".$res['cod_fun'], MYSQLI_STORE_RESULT );
                $res['permite_cancelar'] = $stmt2->num_rows > 0 ? 'S' : 'N';
                
                $stmt3 = $this->__bd->query( "SELECT cod_fun FROM usuario_modulos WHERE atalho = 'ConcederDescontoDispositivosMoveis' AND cod_fun = ".$res['cod_fun'], MYSQLI_STORE_RESULT );
                $res['permite_desconto'] = $stmt3->num_rows > 0 ? 'S' : 'N';
                
                $stmt4 = $this->__bd->query( "SELECT cod_fun FROM usuario_modulos WHERE atalho = 'ConsultarPedidoDispositivosMoveis' AND cod_fun = ".$res['cod_fun'], MYSQLI_STORE_RESULT );
                $res['permite_consulta'] = $stmt4->num_rows > 0 ? 'S' : 'N';
                
                $stmt5 = $this->__bd->query( "SELECT cod_fun FROM usuario_modulos WHERE atalho = 'EmitirPreFechamentoDispositivosMoveis' AND cod_fun = ".$res['cod_fun'], MYSQLI_STORE_RESULT );
                $res['permite_prefechamento'] = $stmt5->num_rows > 0 ? 'S' : 'N';
                
                $stmt6 = $this->__bd->query( "SELECT cod_fun FROM usuario_modulos WHERE atalho = 'RealizarPedidoDispositivosMoveis' AND cod_fun = ".$res['cod_fun'], MYSQLI_STORE_RESULT );
                $res['permite_venda'] = $stmt6->num_rows > 0 ? 'S' : 'N';
                
                $stmt7 = $this->__bd->query( "SELECT cod_fun FROM usuario_modulos WHERE atalho = 'RealizarTransferenciaDispositivosMoveis' AND cod_fun = ".$res['cod_fun'], MYSQLI_STORE_RESULT );
                $res['permite_transferencia'] = $stmt7->num_rows > 0 ? 'S' : 'N';

                $stmt8 = $this->__bd->query( "SELECT cod_fun FROM usuario_modulos WHERE atalho = 'RealizarFechamentoDispositivosMoveis' AND cod_fun = ".$res['cod_fun'], MYSQLI_STORE_RESULT );
                $res['permite_fecharconta'] = $stmt8->num_rows > 0 ? 'S' : 'N';

                $stmt9 = $this->__bd->query( "SELECT cod_fun FROM usuario_modulos WHERE atalho = 'RemoverServicoDispositivosMoveis' AND cod_fun = ".$res['cod_fun'], MYSQLI_STORE_RESULT );
                $res['permite_remover_servico'] = $stmt9->num_rows > 0 ? 'S' : 'N';

                $stmt10 = $this->__bd->query( "SELECT cod_fun FROM usuario_modulos WHERE atalho = 'TEFDedicado' AND cod_fun = ".$res['cod_fun'], MYSQLI_STORE_RESULT );
                $res['permite_tef_adm'] = $stmt10->num_rows > 0 ? 'S' : 'N';
                
                $this->ListaDeOperadores[] = $res;
                
            }
            
            $stmt->close();
            return $this->ListaDeOperadores;
            
        }else{
            
            return false;
            
        }
        
    }


    /**
     * Lista as justificativas de cancelamentos pre-cadastrados pela loja
     * @param string $operacao Variável que indica qual é a operação, comanda ou mesa
     * @return array Lista com todas as justificativas
     */
    protected $ListaDeJustificativas = array();
    
    protected function listaJustificativasCancelamento(){     

        $stmt = $this->__bd->query( "SELECT tipo_cancelamento.cod_tipo_cancelamento, tipo_cancelamento.descricao FROM tipo_cancelamento", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['cod_tipo_cancelamento'] = $row['cod_tipo_cancelamento'];
                $res['descricao']             = $row['descricao'];

                $this->ListaDeJustificativas[] = $res;
                
            }
            
            $stmt->close();
            return $this->ListaDeJustificativas;
            
        }else{
            
            return false;
            
        }
        
    }


    /**
     * Carrega o modulo de cuponeria
     * @return array Lista com os dados do modulo de cuponeria
     */
    
    protected function carregaModuloCuponeria(){     

        $stmt = $this->__bd->prepare( "SELECT cuponeria FROM modulos_sistema" );
        $stmt->execute();
        $stmt->bind_result($cuponeria);
        $stmt->fetch();
        $stmt->close();
        
        return $cuponeria;
        
    }


    /**
     * Lista os tipos de desconto pre-cadastrados pela loja
     * @return array Lista com todas os tipos de desconto
     */
    protected $ListaDeTiposDescontos = array();
    
    protected function listaTiposDescontos(){    

        $stmt = $this->__bd->query( "SELECT tipos_descontos.id,
                                            tipos_descontos.cod_loja,
                                            tipos_descontos.cod_tipo_desc,
                                            tipos_descontos.cod_tipo_cliente,
                                            tipos_descontos.descr_desconto,
                                            tipos_descontos.tipo_desconto,
                                            tipos_descontos.vlr_desconto,
                                            tipos_descontos.vlr_minimo,
                                            tipos_descontos.vlr_maximo,
                                            tipos_descontos.flag_dely,
                                            tipos_descontos.origem_venda,
                                            tipos_descontos.qtde_minima,
                                            tipos_descontos.qtde_maxima,
                                            tipos_descontos.data_hora_ini_vigencia,
                                            tipos_descontos.data_hora_fim_vigencia,
                                            tipos_descontos.uso_automatico,
                                            tipos_descontos.dias_semana,
                                            tipos_descontos.prioridade,
                                            tipos_descontos.desconto_em,
                                            tipos_descontos.data_hora_cadastro,
                                            tipos_descontos.data_hora_atualizacao,
                                            tipos_descontos.ativo
                                        FROM tipos_descontos", MYSQLI_STORE_RESULT );
        
        if( $stmt->num_rows > 0 ){
            
            while( $row = $stmt->fetch_assoc() ){

                $res['id']                     = $row['id'];
                $res['cod_loja']               = $row['cod_loja'];
                $res['cod_tipo_desc']          = $row['cod_tipo_desc'];
                $res['cod_tipo_cliente']       = $row['cod_tipo_cliente'];
                $res['descr_desconto']         = $row['descr_desconto'];
                $res['tipo_desconto']          = $row['tipo_desconto'];
                $res['vlr_desconto']           = $row['vlr_desconto'];
                $res['vlr_minimo']             = $row['vlr_minimo'];
                $res['flag_dely']              = $row['flag_dely'];
                $res['origem_venda']           = $row['origem_venda'];
                $res['qtde_minima']            = $row['qtde_minima'];
                $res['qtde_maxima']            = $row['qtde_maxima'];
                $res['data_hora_ini_vigencia'] = $row['data_hora_ini_vigencia'];
                $res['data_hora_fim_vigencia'] = $row['data_hora_fim_vigencia'];
                $res['uso_automatico']         = $row['uso_automatico'];
                $res['dias_semana']            = $row['dias_semana'];
                $res['prioridade']             = $row['prioridade'];
                $res['desconto_em']            = $row['desconto_em'];
                $res['data_hora_cadastro']     = $row['data_hora_cadastro'];
                $res['data_hora_atualizacao']  = $row['data_hora_atualizacao'];
                $res['ativo']                  = $row['ativo'];

                $this->ListaDeTiposDescontos[] = $res;
                
            }
            
            $stmt->close();
            return $this->ListaDeTiposDescontos;
            
        }else{
            
            return false;
            
        }
        
    }


    

    
    /**
     * Verifica se o número IP do device existe na tabela ipocket da loja
     * Também verifica a parte do sistema de Login na versao 1.15.0 para entregar as variáveis pertinentes
     * @param string $ip Contém o número IP do device
     * @return array Retorna se o device está na lista e liberado para uso
     */
    protected function buscaDevicePorIP( $ip ){

        $res['usa_dispositivos_moveis_por_login'] = 'N';
        $res['qtde_pockets'] = 0;
        try{

            $stmt_login = $this->__bd->query("SELECT usa_dispositivos_moveis_por_login, qtde_pockets FROM parametros", MYSQLI_STORE_RESULT);
            
                $row_login = $stmt_login->fetch_assoc();

                $res['usa_dispositivos_moveis_por_login'] = $row_login['usa_dispositivos_moveis_por_login'];
                $res['qtde_pockets'] = $row_login['qtde_pockets'];
            $stmt_login->close();
        } catch ( Exception $ex ) {
                
        }
        

        if( $res['usa_dispositivos_moveis_por_login'] == 'S' || file_exists( 'C:\\WinEclt\\numpocketegarcompro.txt' ) ){

            $stmt = $this->__bd->query("SELECT palm, ip_local, checkin FROM ipocket WHERE palm = '1' AND checkin = 'S'", MYSQLI_STORE_RESULT);

            if( $stmt->num_rows > 0 ){

                $res['palm']        = 1;
                $res['checkin']     = 'S';
                $res['ip']          = $ip;
                $res['liberado']    = 'S';
                $res['liberacao_global']    = 'S';

                
                $stmt->close();
                return $res;

            }else{

                $res['palm']        = 1;
                $res['checkin']     = 'N';
                $res['ip']          = $ip;
                $res['liberado']    = 'S';
                $res['liberacao_global']    = 'S';
                
                $stmt->close();
                return $res;
            }

        }else{

            $stmt = $this->__bd->query("SELECT palm, ip_local, checkin FROM ipocket WHERE ip_local = '$ip'", MYSQLI_STORE_RESULT);
        
            if( $stmt->num_rows > 0 ){
                
                $row = $stmt->fetch_assoc();
                    
                $res['palm']        = $row['palm'];
                $res['checkin']     = $row['checkin'];
                $res['ip']          = $ip;
                $res['liberado']    = 'S';
                $res['liberacao_global']    = 'N';

                $stmt->close();
                return $res;
                
                
            }else{
                
                $res['palm']        = 0;
                $res['checkin']     = 'N';
                $res['ip']          = $ip;
                $res['liberado']    = 'N';
                $res['liberacao_global']    = 'N';
                
                $stmt->close();
                return $res;
            }
        }
    }
    
    /**
     * Seleciona informações da versão do aplicativo do pocket na loja e caminho do socket de comunicação
     * @return array Retorna dados acima num vetor
     */
    protected function dadosPocketMultisaborAndSocket(){
        
        $stmt = $this->__bd->query("SELECT versao_pocket, 
                                            data_limite_atu_pocket, 
                                            porta_socket, 
                                            ip_socket, 
                                            meia_pizza, 
                                            valor_pizza,
                                            usa_pre_fechamento_individual,
                                            usa_justificativa_canc_item_mesa,
                                            usa_justificativa_canc_item_comanda 
                                            FROM parametros", MYSQLI_STORE_RESULT);
        
        if( $stmt->num_rows > 0 ){
            
            $row = $stmt->fetch_assoc();
                
            $res['versao_pocket']              = $row['versao_pocket'];
            $res['data_limite_atu_pocket']     = substr( $row['data_limite_atu_pocket'], 0, 10 );
            $res['porta_socket']               = $row['porta_socket'];
            $res['ip_socket']                  = $row['ip_socket'];
            $res['meia_pizza']                 = $row['meia_pizza'];
            $res['valor_pizza']                = $row['valor_pizza'];
            $res['usa_pre_fechamento_individual'] = $row['usa_pre_fechamento_individual'];
            $res['usa_justificativa_canc_item_mesa'] = $row['usa_justificativa_canc_item_mesa'];
            $res['usa_justificativa_canc_item_comanda'] = $row['usa_justificativa_canc_item_comanda'];

            $stmt = $this->__bd->query("SELECT desconto_maximo FROM numeros");
            $row = $stmt->fetch_assoc();

            $res['desconto_maximo'] = $row['desconto_maximo'];
            

            return $res;
            
            
        }else{
            
            return false;
        }
    }
    
    /**
     * Transforma cor RGB para HEX e envia cor de fonte branca ou preta em melhor contraste com esta cor
     * @param string $cor Cor em RGB a ser formatada
     * @return array Dados da cor em hexadecimal e cor de fonte em contraste
     */
    protected function rgbToHexAndContrast( $cor ){
        
        //transforma rgb para hexadecimal
        $cor = explode( ',', $cor );
        $r = $cor[0] < 16 ? '0'. dechex( $cor[0] ) : dechex( $cor[0] );
        $g = $cor[1] < 16 ? '0'. dechex( $cor[1] ) : dechex( $cor[1] );
        $b = $cor[2] < 16 ? '0'. dechex( $cor[2] ) : dechex( $cor[2] );
        $hex = $r.$g.$b;
        
        //calcula contraste com preto
        $preto = ( max($cor[0], 0) - min($cor[0], 0) ) + ( max($cor[1], 0) - min($cor[1], 0) ) + ( max($cor[2], 0) - min($cor[2], 0) );
        
        //calcula contraste com branco
        $branco = ( max($cor[0], 255) - min($cor[0], 255) ) + ( max($cor[1], 255) - min($cor[1], 255) ) + ( max($cor[2], 255) - min($cor[2], 255) );
        
        $fonte = ( $preto >= $branco ) ? "000000" : "ffffff";
        
        $res['hex'] = '#'.$hex;
        $res['fonte_hex'] = '#'.$fonte;
        
        return $res;
    }


    /**
     * Diminui imagem em base64 para um tamanho compativel com as principais impressoras pinpad do mercado
     * @param string $img Imagem original em base64 para ser diminuida
     * @return string imagem diminuida a partir do imagick
     */
    protected function diminuiTamanhoImagem( $json ){

    
        $url = "https://www.pedidoviaweb.com.br/ws/print/index.php?metodo=getImageResized";

        $curl = curl_init();
        curl_setopt( $curl, CURLOPT_POST, 1 );
        curl_setopt( $curl, CURLOPT_POSTFIELDS, $json );
        curl_setopt( $curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt( $curl, CURLOPT_HTTPHEADER,array( 'loginToken: c8567f1f1ba8b9633947819de9af50ec29c2ead1' ) );
        curl_setopt( $curl, CURLOPT_URL, $url );

        
        curl_setopt( $curl, CURLOPT_SSLVERSION, 6 );
        curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);

        
            $result = curl_exec($curl);
            $result = json_decode($result);
            $img = $result->dados_adicionais->img_small;
        
        curl_close($curl);

        $res['img'] = $img;
        $res['return'] = true;

        return $res;
        
    }
    
    /**
     * Conecta com o banco do servidor
     * @param string $os Informação do Sistema Operacional para validações extras
     * @param bool $debug Booleano para informar se a aplicaçao está rodando em debug ou não
     * @return array Dados da conexão do banco de dados do servidor da loja
     */
    protected function conectaBancoLocal( $os, $debug=false ){
        
        try{
            if( $os === 'mac' || $os === 'linux' ){
                $arquivo = "C:\\WinEclt\\ConexaoLoja.xml";
                //$arquivo = "ConexaoLoja.xml"; // p/ simular no Mac/Linux
            }else{
                $arquivo = "C:\\WinEclt\\ConexaoLoja.xml";
                //$arquivo = "ConexaoLoja.xml";
            }
            
            
            $manipulador        = ( fopen( $arquivo, "r" ) );
            $conteudocript      = ( fread ( $manipulador, filesize ( $arquivo ) ) );
            fclose ($manipulador);
            $xmldescript        = base64_decode( $conteudocript );
            $rXML               = simplexml_load_string( $xmldescript );
            
            
            $res['nomebanco']   = strval( $rXML->conexoes->ecleticavendas->nomeBanco );
            $res['host']        = strval( $rXML->conexoes->ecleticavendas->host );
            
            //teste usando host do marcelo
            //$res['host'] = "192.168.0.15";
            
            
            
            $res['porta']       = strval( $rXML->conexoes->ecleticavendas->porta );
            $res['usuario']     = strval( $rXML->conexoes->ecleticavendas->usuario );
            $res['senha']       = strval( $rXML->conexoes->ecleticavendas->senha );
            $res['estacaoweb']  = strval( $rXML->estacaoWeb );
            
            
            //estes dados de socket deverao ser pegos do banco de dados em configuracoes iniciais
            //$res['porta_socket'] = "6550";
            //$res['ip_socket'] = "192.168.0.15";
             

        } catch ( Exception $ex ) {
                
            return false;
        }
        
        return $res;
        
        
        
    }
}
